# Complete VSCode Setup for Savly Platform

## Quick Download Checklist

To move this project to VSCode, you need to download these files from Replit:

### 📁 Core Python Files
- [x] `app.py` - Flask application setup
- [x] `models.py` - Database models
- [x] `routes.py` - All application routes
- [x] `main.py` - Entry point (VSCode optimized)
- [x] `run_local.py` - Local development helper

### 📁 Configuration Files
- [x] `.env.example` - Environment variables template
- [x] `.vscode/settings.json` - VSCode Python settings
- [x] `.vscode/launch.json` - Debug configurations
- [x] `.gitignore` - Git ignore rules
- [x] `VSCODE_SETUP.md` - Detailed setup guide

### 📁 Template Directory (Complete folder)
```
templates/
├── admin/
│   ├── base_admin.html
│   ├── enhanced_dashboard.html
│   ├── profile_settings.html
│   ├── analytics_dashboard.html
│   ├── notification_center.html
│   ├── members.html
│   ├── add_member.html
│   ├── edit_member.html
│   ├── contributions.html
│   ├── add_contribution.html
│   ├── bulk_import.html
│   ├── events.html
│   ├── add_event.html
│   └── reports.html
├── member/
│   ├── base_member.html
│   ├── dashboard.html
│   ├── profile.html
│   ├── contributions.html
│   ├── events.html
│   ├── submit_contribution.html
│   ├── request_loan.html
│   └── requests.html
├── public/
│   ├── index.html
│   ├── admin_login.html
│   ├── member_login.html
│   └── group_signup.html
└── superadmin/
    ├── base.html
    ├── dashboard.html
    ├── groups.html
    ├── group_members.html
    ├── financial.html
    ├── audit_logs.html
    ├── backup_export.html
    ├── security.html
    ├── settings.html
    ├── bulk_actions.html
    ├── monitor.html
    ├── user_management.html
    └── reports.html
```

## 🚀 Quick Setup Commands

1. **Create Project Directory**
```bash
mkdir savly-platform
cd savly-platform
```

2. **Download Files** (from Replit file manager)
```bash
# Download all files listed above into this directory
# Maintain the exact folder structure
```

3. **Create Virtual Environment**
```bash
python3 -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate
```

4. **Install Dependencies**
```bash
pip install Flask==2.3.3
pip install Flask-SQLAlchemy==3.0.5
pip install Flask-Login==0.6.2
pip install psycopg2-binary==2.9.7
pip install Werkzeug==2.3.7
pip install python-dotenv==1.0.0
pip install gunicorn==21.2.0
```

5. **Setup Environment**
```bash
cp .env.example .env
# Edit .env with your database settings
```

6. **Database Setup (Choose One)**

**Option A: PostgreSQL**
```bash
brew install postgresql
brew services start postgresql
createdb savly_development
# Update .env: DATABASE_URL=postgresql://username:password@localhost/savly_development
```

**Option B: SQLite (Easier)**
```bash
# Update .env: DATABASE_URL=sqlite:///savly.db
```

7. **Initialize Database**
```bash
python run_local.py
# This will create tables and start the server
```

## 🎯 VSCode Extensions

Install these in VSCode (Ctrl+Shift+X):
- **Python** (Microsoft) - Essential
- **Flask-Snippets** - Flask code completion
- **SQLTools** - Database management
- **GitLens** - Git integration
- **Auto Rename Tag** - HTML tag sync

## 🔧 Running the Application

### Method 1: Debug Mode (Recommended)
1. Open VSCode
2. Press `F5`
3. Select "Flask Debug"
4. Application starts with debugger attached

### Method 2: Terminal
```bash
source venv/bin/activate
python run_local.py
```

### Method 3: Simple Run
```bash
python main.py
```

## 🌐 Access URLs

- **Home**: http://localhost:5001
- **Admin Login**: http://localhost:5001/admin/login
- **Member Login**: http://localhost:5001/member/login

## 🔑 Login Credentials

### Superadmin
- Username: `admin`
- Password: `admin123`

### Group Admin (Amader Somity)
- Username: `amader`
- Password: `22558822`

### Members
- Any member ID (M001-M022)
- Password: `1234`

## 📝 Development Tips

### VSCode Shortcuts
- `F5` - Start debugging
- `Ctrl+Shift+P` - Command palette
- `F12` - Go to definition
- `Ctrl+`\` - Toggle terminal

### Project Structure
```
savly-platform/
├── app.py               # Flask app setup
├── models.py            # Database models
├── routes.py            # Application routes
├── main.py              # Entry point
├── run_local.py         # Development helper
├── .env                 # Environment variables
├── .gitignore          # Git ignore rules
├── .vscode/            # VSCode configuration
│   ├── settings.json
│   └── launch.json
└── templates/          # All HTML templates
    ├── admin/
    ├── member/
    ├── public/
    └── superadmin/
```

### Database Management
```bash
# Create tables
python -c "from app import app, db; app.app_context().push(); db.create_all()"

# Reset database (development only)
python -c "from app import app, db; app.app_context().push(); db.drop_all(); db.create_all()"
```

### Git Setup
```bash
git init
git add .
git commit -m "Initial VSCode setup"
```

## 🐛 Troubleshooting

### Port 5000 Busy (macOS AirPlay)
- Application runs on port 5001 by default
- Check `.env` file: `PORT=5001`

### Database Issues
```bash
# Check PostgreSQL
brew services list | grep postgresql

# For SQLite permissions
chmod 755 .
```

### Python Virtual Environment
```bash
# Reset if needed
rm -rf venv
python3 -m venv venv
source venv/bin/activate
pip install -r requirements.txt
```

## 📦 Production Deployment

### Heroku
```bash
echo "web: gunicorn main:app" > Procfile
git push heroku main
```

### Namecheap cPanel
1. Upload all files
2. Create Python app
3. Set entry point: `main:app`
4. Install requirements

## ✅ Verification Checklist

After setup, verify:
- [ ] VSCode opens project without errors
- [ ] Python interpreter points to venv
- [ ] F5 debugging works
- [ ] Application loads at localhost:5001
- [ ] Admin login works (admin/admin123)
- [ ] Member login works (M001/1234)
- [ ] Database queries work
- [ ] Profile dropdown functions
- [ ] Analytics dashboard loads

## 🎉 Success!

Your Savly platform is now ready for VSCode development with:
- ✅ Full debugging support
- ✅ Professional development environment
- ✅ Modern admin interface with enhanced profile system
- ✅ Complete member self-service portal
- ✅ Comprehensive superadmin tools
- ✅ Multi-group support with data isolation
- ✅ Production deployment capability

The platform includes all recent enhancements:
- Enhanced profile dropdown with animations
- Comprehensive profile settings page
- Advanced analytics dashboard
- Notification center
- Bulk import capabilities
- Member self-service features
- Complete admin panel redesign

You're ready to continue development in your preferred VSCode environment!