#!/usr/bin/env python3
"""
Main entry point for Savly Group Savings Management Platform
VSCode-optimized version with environment variable support
"""

import os
from dotenv import load_dotenv

# Load environment variables from .env file
load_dotenv()

from app import app

if __name__ == '__main__':
    # Get configuration from environment variables
    host = os.environ.get('HOST', '0.0.0.0')
    port = int(os.environ.get('PORT', 5001))
    debug = os.environ.get('FLASK_DEBUG', 'True').lower() == 'true'
    
    print(f"🚀 Starting Savly Platform on http://{host}:{port}")
    print(f"📊 Debug mode: {debug}")
    print(f"🗄️  Database: {os.environ.get('DATABASE_URL', 'Not configured')}")
    
    app.run(
        host=host,
        port=port,
        debug=debug,
        use_reloader=debug
    )